<?php
namespace DataAlign_Woo;

// If uninstall not called from WordPress, exit.
if (!\defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Run uninstall without declaring globals in file scope.
(new class {
    public function run(): void {
    // Remove plugin options and (by default) plugin-specific post meta for full cleanup.
    // Site owners can override via filters below.

    $option_keys = [
    // Settings
    'dataalign_api_base_url', // legacy, safe to delete if present
    'dataalign_api_key',
    'dataalign_public_base_url',
    'dataalign_exclude_images',
    'dataalign_sync_attributes_to_woo',
    'dataalign_only_fill_empty_attributes',
    'dataalign_enable_specs_tab',
    'dataalign_specs_tab_title',
    'dataalign_map_seo_to_plugins',
    'dataalign_seo_fill_only_empty',
    // Job/options state
    '_dataalign_last_global_error',
    '_dataalign_bulk_enrich_job',
    '_dataalign_restore_all_job',
    '_dataalign_site_id',
    '_dataalign_plan_name',
    '_dataalign_plan_limit',
    ];

    // Allow filtering the list of options to delete.
    // Allow external code to adjust the list; keep legacy filter name for compatibility.
    $option_keys = apply_filters('dataalign_uninstall_option_keys', $option_keys);

    foreach ((array) $option_keys as $key) {
        if (is_string($key) && $key !== '') {
            delete_option($key);
        }
    }

    // Delete plugin post meta by default; can be disabled via filter if preservation is desired.
    $delete_post_meta = (bool) apply_filters('dataalign_uninstall_delete_post_meta', true);
    if ($delete_post_meta) {
        global $wpdb;
        // Plugin-specific post meta keys to remove
        $meta_keys = [
        '_dataalign_attributes',
        '_dataalign_seo_title',
        '_dataalign_seo_meta_description',
        '_dataalign_last_job_id',
        '_dataalign_last_result',
        '_dataalign_last_enriched',
        '_dataalign_last_error',
        '_dataalign_job_ids',
        '_dataalign_completed_job_ids',
        '_dataalign_has_pending_jobs',
        '_dataalign_ai_tag_ids',
        '_dataalign_preserved_tag_ids',
        '_dataalign_preserved_attributes',
        '_dataalign_preserved_wc_attributes',
        '_dataalign_preserved_seo_title',
        '_dataalign_preserved_seo_description',
        '_dataalign_bulk_run',
        '_dataalign_bulk_applied',
        ];
        $meta_keys = (array) apply_filters('dataalign_uninstall_post_meta_keys', $meta_keys);
        if (!empty($meta_keys)) {
            // Inline the dynamic placeholder list to keep prepare() visible without interpolating a variable into the SQL string
            // phpcs:ignore WordPress.DB.DirectDatabaseQuery
            $wpdb->query(
                $wpdb->prepare(
                    "DELETE FROM {$wpdb->postmeta} WHERE meta_key IN (" . implode(', ', array_fill(0, count($meta_keys), '%s')) . ")",
                    ...$meta_keys
                )
            );
        }
    }
    }
})->run();
