/* global jQuery, DataAlignWoo */
(function ($) {
  'use strict';

  function getCtx() {
    var productId = $('#dataalign-product-id').val() || (DataAlignWoo && DataAlignWoo.productId) || 0;
    var nonce = $('#dataalign-enrich-nonce').val() || (DataAlignWoo && DataAlignWoo.nonce) || '';
    var syncNonce = $('#dataalign-sync-nonce').val() || '';
    var restoreNonce = $('#dataalign-restore-nonce').val() || '';
    return { productId: parseInt(productId, 10) || 0, nonce: nonce, syncNonce: syncNonce, restoreNonce: restoreNonce };
  }

  function setStatus(html) {
    $('#dataalign-status').html(html);
  }

  function refreshAttributesBox() {
    var ctx = getCtx();
    if (!ctx.productId || !ctx.nonce) return;
    var $box = $('#dataalign-attributes-box');
    if ($box.length === 0) return;
    $.ajax({
      url: (DataAlignWoo && DataAlignWoo.ajaxUrl) || ajaxurl,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'dataalign_get_attributes',
        product_id: ctx.productId,
        nonce: ctx.nonce
      }
    }).done(function (res) {
      if (res && res.success && res.data && typeof res.data.html === 'string') {
        $box.html(res.data.html);
      }
    });
  }

  function refreshWooAttributesPanel() {
    var ctx = getCtx();
    if (!ctx.productId || !ctx.nonce) return;
    var $container = $('#product_attributes .product_attributes');
    if ($container.length === 0) return;
    $.ajax({
      url: (DataAlignWoo && DataAlignWoo.ajaxUrl) || ajaxurl,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'dataalign_get_wc_attributes',
        product_id: ctx.productId,
        nonce: ctx.nonce
      }
    }).done(function (res) {
      if (res && res.success && res.data && typeof res.data.html === 'string') {
        $container.html(res.data.html);
        // Re-init Woo select2 and tooltips in case taxonomy attributes are present.
        $(document.body).trigger('wc-enhanced-select-init');
        $(document.body).trigger('init_tooltips');
      }
    });
  }

  function refreshWooTagsBox() {
    var ctx = getCtx();
    if (!ctx.productId || !ctx.nonce) return;
    var $tagsDiv = $('#tagsdiv-product_tag');
    if ($tagsDiv.length === 0) return;
    $.ajax({
      url: (DataAlignWoo && DataAlignWoo.ajaxUrl) || ajaxurl,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'dataalign_get_product_tags',
        product_id: ctx.productId,
        nonce: ctx.nonce
      }
    }).done(function (res) {
      if (res && res.success && res.data && $.isArray(res.data.tags)) {
        var tags = res.data.tags || [];
        var delim = (window.wp && window.wp.i18n && window.wp.i18n._x) ? window.wp.i18n._x(',', 'tag delimiter') : ',';
        var str = tags.join(delim + ' ');
        var $theTags = $tagsDiv.find('.the-tags');
        if ($theTags.length) {
          $theTags.val(str);
          if (window.tagBox && typeof window.tagBox.quickClicks === 'function') {
            window.tagBox.quickClicks($tagsDiv[0]);
          }
        }
      }
    });
  }

  $(document).on('click', '#dataalign-enrich-button', function () {
    var $btn = $(this);
    var $spinner = $('#dataalign-enrich-spinner');
    var ctx = getCtx();

    if (!ctx.productId || !ctx.nonce) {
      return;
    }

    $btn.prop('disabled', true);
    $spinner.addClass('is-active');
    setStatus('<p>' + (DataAlignWoo && DataAlignWoo.i18n ? DataAlignWoo.i18n.working : 'Working…') + '</p>');

    $.ajax({
      url: (DataAlignWoo && DataAlignWoo.ajaxUrl) || ajaxurl,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'dataalign_enrich_product',
        product_id: ctx.productId,
        nonce: ctx.nonce
      }
    }).done(function (res) {
      if (res && res.success) {
        var msg = (res.data && res.data.message) || (DataAlignWoo && DataAlignWoo.i18n ? DataAlignWoo.i18n.success : 'Success');
        setStatus('<p>' + msg + '</p>');
        // Attributes may have been updated; refresh our box and Woo panel
        refreshAttributesBox();
        refreshWooAttributesPanel();
        refreshWooTagsBox();
      } else {
        var emsg = (res && res.data && res.data.message) || (DataAlignWoo && DataAlignWoo.i18n ? DataAlignWoo.i18n.error : 'Error');
        var extra = '';
        if (res && res.data && res.data.upgradeUrl) {
          extra = ' <a class="button button-primary" style="margin-left:6px" href="' + String(res.data.upgradeUrl) + '" target="_blank" rel="noopener noreferrer">Upgrade Plan</a>';
        }
        setStatus('<p style="color:#b32d2e;">' + emsg + extra + '</p>');
      }
    }).fail(function () {
      var emsg = (DataAlignWoo && DataAlignWoo.i18n ? DataAlignWoo.i18n.error : 'Error');
      setStatus('<p style="color:#b32d2e;">' + emsg + '</p>');
    }).always(function () {
      $spinner.removeClass('is-active');
      $btn.prop('disabled', false);
    });
  });

  // Sync attributes to Woo
  $(document).on('click', '#dataalign-sync-attributes', function () {
    var $btn = $(this);
    var $spinner = $('#dataalign-sync-spinner');
    var $status = $('#dataalign-sync-status');
    var ctx = getCtx();

    if (!ctx.productId || !ctx.syncNonce) return;

    $btn.prop('disabled', true);
    $spinner.addClass('is-active');
    $status.text('');

    $.ajax({
      url: (DataAlignWoo && DataAlignWoo.ajaxUrl) || ajaxurl,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'dataalign_sync_attributes',
        product_id: ctx.productId,
        nonce: ctx.syncNonce
      }
    }).done(function (res) {
      if (res && res.success) {
        var msg = (res.data && res.data.message) || 'Synced.';
        $status.html('<span style="color:#008a20">' + msg + '</span>');
        refreshWooAttributesPanel();
        refreshWooTagsBox();
      } else {
        var emsg = (res && res.data && res.data.message) || 'Failed.';
        $status.html('<span style="color:#b32d2e">' + emsg + '</span>');
      }
    }).fail(function () {
      $status.html('<span style="color:#b32d2e">Failed.</span>');
    }).always(function () {
      $spinner.removeClass('is-active');
      $btn.prop('disabled', false);
    });
  });

  // Restore baseline tags & attributes
  $(document).on('click', '#dataalign-restore-baseline', function () {
    var $btn = $(this);
    var $spinner = $('#dataalign-restore-spinner');
    var $status = $('#dataalign-restore-status');
    var ctx = getCtx();

    if (!ctx.productId || !ctx.restoreNonce) return;

    $btn.prop('disabled', true);
    $spinner.addClass('is-active');
    $status.text('');

    $.ajax({
      url: (DataAlignWoo && DataAlignWoo.ajaxUrl) || ajaxurl,
      method: 'POST',
      dataType: 'json',
      data: {
        action: 'dataalign_restore_baseline',
        product_id: ctx.productId,
        nonce: ctx.restoreNonce
      }
    }).done(function (res) {
      if (res && res.success) {
        var msg = (res.data && res.data.message) || 'Restored.';
        $status.html('<span style="color:#008a20">' + msg + '</span>');
      } else {
        var emsg = (res && res.data && res.data.message) || 'Failed.';
        $status.html('<span style="color:#b32d2e">' + emsg + '</span>');
      }
    }).fail(function () {
      $status.html('<span style="color:#b32d2e">Failed.</span>');
    }).always(function () {
      $spinner.removeClass('is-active');
      $btn.prop('disabled', false);
    });
  });
})(jQuery);
