/* Animated button helpers: ripple on click and focus ring bump */
(function () {
  'use strict';

  function addRipple(e) {
    var btn = e.currentTarget;
    try {
      var rect = btn.getBoundingClientRect();
      var x = e.clientX - rect.left;
      var y = e.clientY - rect.top;
      var ripple = document.createElement('span');
      ripple.className = 'da-ripple';
      ripple.style.left = x + 'px';
      ripple.style.top = y + 'px';
      btn.appendChild(ripple);
      setTimeout(function () {
        if (ripple && ripple.parentNode) ripple.parentNode.removeChild(ripple);
      }, 750);
    } catch (err) {
      // no-op
    }
  }

  function bumpFocus(e) {
    var el = e.currentTarget;
    el.style.transform = 'translateY(-1px)';
    setTimeout(function () { el.style.transform = ''; }, 120);
  }

  function ready(fn) {
    if (document.readyState === 'loading') {
      document.addEventListener('DOMContentLoaded', fn);
    } else {
      fn();
    }
  }

  function injectAISparkle(btn) {
    if (!btn || btn.querySelector('.da-ai-star')) return;
    // Mark and pad the button
    if (!btn.classList.contains('da-ai-has-star')) btn.classList.add('da-ai-has-star');
    var span = document.createElement('span');
    span.className = 'da-ai-star';
    span.setAttribute('aria-hidden', 'true');
    // Lightweight star SVG
    span.innerHTML = '\n      <svg width="14" height="14" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">\n        <path d="M12 2.5l2.6 5.27 5.82.85-4.21 4.1.99 5.78L12 16.92 6.8 18.5l.99-5.78L3.58 8.62l5.82-.85L12 2.5z" fill="currentColor"/>\n      </svg>';
    btn.insertBefore(span, btn.firstChild);
  }

  ready(function () {
    var selectors = [
      // Admin settings page
      '.dataalign-settings .button-primary',
      '.dataalign-settings #dataalign-test-connection',
      '.dataalign-settings #dataalign-register-site',
      // Product editor metabox
      '#dataalign-enrich-button',
      '#dataalign-sync-attributes'
    ].join(',');

    var buttons = document.querySelectorAll(selectors);
    buttons.forEach(function (btn) {
      btn.addEventListener('click', addRipple, { passive: true });
      btn.addEventListener('focus', bumpFocus, { passive: true });
      // Add AI sparkle only to DataAlign admin/product buttons, not to add-to-cart
      if (btn.matches('#dataalign-enrich-button, #dataalign-sync-attributes, .dataalign-settings .button-primary, .dataalign-settings #dataalign-test-connection, .dataalign-settings #dataalign-register-site')) {
        injectAISparkle(btn);
      }
    });
  });
})();
